<?php
defined('ABSPATH') || exit;

class IranDargah_REST_Endpoints {
    
    public static function init() {
        add_action('rest_api_init', [__CLASS__, 'register_routes']);
    }
    
    public static function register_routes() {
        register_rest_route('irandargah/v1', '/toggle-gateway', [
            'methods' => 'POST',
            'callback' => [__CLASS__, 'toggle_gateway'],
            'permission_callback' => [__CLASS__, 'check_permission'],
        ]);
        
        register_rest_route('irandargah/v1', '/save-settings', [
            'methods' => 'POST',
            'callback' => [__CLASS__, 'save_settings'],
            'permission_callback' => [__CLASS__, 'check_permission'],
        ]);
        
        register_rest_route('irandargah/v1', '/get-settings', [
            'methods' => 'GET',
            'callback' => [__CLASS__, 'get_settings'],
            'permission_callback' => [__CLASS__, 'check_permission'],
        ]);
        
        register_rest_route('irandargah/v1', '/get-gateways', [
            'methods' => 'GET',
            'callback' => [__CLASS__, 'get_gateways'],
            'permission_callback' => [__CLASS__, 'check_permission'],
        ]);
    }
    
    public static function check_permission() {
        return current_user_can('manage_options');
    }
    
    public static function toggle_gateway($request) {
        $gateway_id = sanitize_text_field($request->get_param('gateway_id'));
        $enabled = $request->get_param('enabled') === true || $request->get_param('enabled') === 'true';
        
        if (empty($gateway_id)) {
            return new WP_Error('invalid_gateway', __('شناسه درگاه معتبر نیست.', 'irandargah'), ['status' => 400]);
        }
        
        IranDargah_Settings_Loader::toggle_gateway($gateway_id, $enabled);
        
        return new WP_REST_Response([
            'success' => true,
            'message' => __('وضعیت درگاه تغییر کرد.', 'irandargah'),
        ], 200);
    }
    
    public static function save_settings($request) {
        $gateway_id = sanitize_text_field($request->get_param('gateway_id'));
        $settings = $request->get_param('settings');
        
        if (empty($gateway_id) || !is_array($settings)) {
            return new WP_Error('invalid_data', __('داده‌های ارسالی معتبر نیست.', 'irandargah'), ['status' => 400]);
        }
        
        IranDargah_Settings_Loader::save_gateway_settings($gateway_id, $settings);
        
        return new WP_REST_Response([
            'success' => true,
            'message' => __('تنظیمات با موفقیت ذخیره شد.', 'irandargah'),
        ], 200);
    }
    
    public static function get_settings($request) {
        $gateway_id = sanitize_text_field($request->get_param('gateway_id'));
        
        if (empty($gateway_id)) {
            return new WP_Error('invalid_gateway', __('شناسه درگاه معتبر نیست.', 'irandargah'), ['status' => 400]);
        }
        
        $option_name = "woocommerce_{$gateway_id}_settings";
        $settings = get_option($option_name, []);
        
        return new WP_REST_Response([
            'success' => true,
            'settings' => $settings,
        ], 200);
    }
    
    public static function get_gateways($request) {
        $gateways = IranDargah_Settings_Loader::get_all_gateways_data();
        
        return new WP_REST_Response([
            'success' => true,
            'gateways' => $gateways,
        ], 200);
    }
}

IranDargah_REST_Endpoints::init();

