<?php
// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Declare compatibility with WooCommerce features BEFORE WooCommerce initializes
add_action('before_woocommerce_init', function () {
    if (class_exists('\Automattic\WooCommerce\Utilities\FeaturesUtil')) {
        // Core WooCommerce features (required for compatibility)
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('custom_order_tables', __FILE__, true);
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('cart_checkout_blocks', __FILE__, true);
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('product_block_editor', __FILE__, true);
        
        // Additional features for full compatibility
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('analytics', __FILE__, true);
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('new_navigation', __FILE__, true);
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('store_api', __FILE__, true);
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('subscriptions', __FILE__, true);
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('subscriptions_update', __FILE__, true);
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('woocommerce-blocks', __FILE__, true);
        
        // Payment gateway specific features
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('payment_gateway_suggestions', __FILE__, true);
        
        // Optional features (declare compatibility to prevent warnings)
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('order_attribution', __FILE__, true);
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('minified_css', __FILE__, true);
    }
});

// Include gateway class file
$gateway_file = __DIR__ . "/class-wc-gateway-zarinpal.php";
if (file_exists($gateway_file)) {
    include_once($gateway_file);
}

// Load gateway immediately if WooCommerce is already loaded
// Otherwise register it for later
if (class_exists('WooCommerce') && class_exists('WC_Payment_Gateway')) {
    // WooCommerce is already loaded, call function directly
    if (function_exists('Load_ZarinPal_Gateway') && !class_exists('WC_ZPal')) {
        Load_ZarinPal_Gateway();
    }
} else {
    // WooCommerce not loaded yet, register hooks
    add_action('woocommerce_loaded', function() {
        if (function_exists('Load_ZarinPal_Gateway') && !class_exists('WC_ZPal')) {
            Load_ZarinPal_Gateway();
        }
    }, 10);
    
    // Fallback: also try on plugins_loaded in case woocommerce_loaded already fired
    if (!did_action('plugins_loaded')) {
        add_action('plugins_loaded', function() {
            if (function_exists('Load_ZarinPal_Gateway') && class_exists('WC_Payment_Gateway') && !class_exists('WC_ZPal')) {
                Load_ZarinPal_Gateway();
            }
        }, 20);
    }
}

add_action('woocommerce_blocks_loaded', 'zarinpal_gateway_block_support');
function zarinpal_gateway_block_support() {
    require_once __DIR__ . '/includes/class-wc-zarinpal-gateway-blocks-support.php';
    add_action(
        'woocommerce_blocks_payment_method_type_registration',
        function (Automattic\WooCommerce\Blocks\Payments\PaymentMethodRegistry $payment_method_registry) {
            $payment_method_registry->register(new WC_Zarinpal_Gateway_Blocks_Support);
        }
    );
}
