<?php
function woocommerce_pasargad_payment_init()
{
    
    if (!class_exists('WC_Payment_Gateway'))
        return;
    add_filter('plugin_action_links', array('WC_Pasargad_Gateway', 'pep_wpwc_plugin_action_links'), 10, 2);

    class WC_Pasargad_Gateway extends WC_Payment_Gateway
    {
        // Declare properties to avoid dynamic property notices on PHP 8.2+
        public $redirect_uri;
        public $pasargad_terminal_id;
        public $pasargad_merchant_id;
        public $pasargad_username;
        public $pasargad_password;
        public $title;
        public $description;
        public $success_massage;
        public $failed_massage;
        public $cancelled_massage;
        public $is_finish_order;
        public $orderstatus;
        public $msg = [];
        public function init_settings() {
            parent::init_settings();
        }

        static $username_p = '';
        static $password_p = '';
        static $token_p = '';
        static $my_return_url = '';
        static $base_url ='';
        
        // __construct() of modual - Start
        public function __construct()
        {
            $this->id = 'pasargad';
            $this->method_title = 'درگاه پرداخت الکترونیک پاسارگاد';
            $this->method_description = 'این افزونه درگاه پرداخت الکترونیک پاسارگاد را به روش های پرداختی ووکامرس اضافه می کند';
            $this->has_fields = false;
            $this->redirect_uri = WC()->api_request_url('WC_Pasargad_Gateway');

            $this->icon = apply_filters('pasargad_logo', WP_PLUGIN_URL . '/' . plugin_basename(__DIR__) . '/images/logo.png');
            

            $this->init_form_fields();
            $this->init_settings();
            // $this->init__pepco_table();
            $this->pasargad_terminal_id = self::removeNoNumber($this->get_option('pasargad_terminal_id', ''));
            $this->pasargad_merchant_id = self::removeNoNumber($this->get_option('pasargad_merchant_id', ''));
            
            $this->pasargad_username = $this->get_option('pasargad_username', '');
            $this->pasargad_password = $this->get_option('pasargad_password', '');
            
            self::$password_p =  $this->pasargad_password;
            self::$username_p =  $this->pasargad_username;
            
            $this->title = __($this->get_option('title', 'بانک پاسارگاد'), 'woocommerce');
            $this->description = __($this->get_option('description', 'پرداخت امن به وسیله کلیه کارت های عضو شتاب از طریق بانک پاسارگاد'), 'woocommerce');
            $this->success_massage = __($this->get_option('success_massage', 'با تشکر از شما . سفارش شما با موفقیت پرداخت شد .'), 'woocommerce');
            $this->failed_massage = __($this->get_option('failed_massage', 'پرداخت شما ناموفق بوده است . لطفا مجددا تلاش نمایید یا در صورت بروز اشکال با مدیر سایت تماس بگیرید .'), 'woocommerce');
            $this->cancelled_massage = __($this->get_option('cancelled_massage', 'پرداخت به دلیل انصراف شما ناتمام باقی ماند .'), 'woocommerce');
            $this->msg['message'] = '';
            $this->msg['class'] = '';
            self::$base_url = __($this->get_option('base_url', ''), 'woocommerce');

            $this->is_finish_order  = $this->get_option('is_finish_order', 'no');
            
            
            if ($this->get_option('orderstatus')) {
                $this->orderstatus = $this->get_option('orderstatus');
            } else {
                $this->orderstatus = 1;
            }

            add_action('woocommerce_update_options_payment_gateways_' . $this->id, array($this, 'process_admin_options'));
            add_action('woocommerce_receipt_pasargad', array($this, 'receipt_page'));
            add_action('woocommerce_api_' . strtolower(get_class($this)) . '', array($this, 'callback'));
            
        }
        // __construct() of modual - Start

        public function init_form_fields()
        {
            $this->form_fields = array(
                'enabled' => array(
                    'title' => 'فعال / غیرفعال :',
                    'type' => 'checkbox',
                    'label' => 'فعال یا غیرفعال سازی درگاه پرداخت الکترونیک پاسارگاد',
                    'default' => 'no'
                ),
                'pasargad_terminal_id' => array(
                    'title' => 'شماره ترمینال :',
                    'type' => 'text',
                    'required' => true,
                    'desc_tip' => true,
                ),
                'pasargad_merchant_id' => array(
                    'title' => 'شماره فروشگاه :',
                    'type' => 'text',
                    'required' => true,
                    'desc_tip' => false,
                ),
                'pasargad_username' => array(
                    'title' => 'نام کاربری :',
                    'type' => 'text',
                    'required' => true,
                    'desc_tip' => true,
                ),
                'pasargad_password' => array(
                    'title' => 'کلمه عبور :',
                    'type' => 'password',
                    'required' => true,
                    'desc_tip' => true,
                ),

                'title' => array(
                    'title' => 'عنوان درگاه :',
                    'type' => 'text',
                    'description' => 'این نام در طی فرایند خرید به مشتری نمایش داده می شود',
                    'default' => 'بانک پاسارگاد'
                ),
                'description' => array(
                    'title' => 'توضیحات درگاه',
                    'type' => 'textarea',
                    'description' => 'توضیحاتی که در طی عملیات پرداخت برای درگاه نمایش داده خواهد شد',
                    'default' => 'پرداخت امن به وسیله کلیه کارت های عضو شتاب از طریق بانک پاسارگاد'
                ),
                'success_massage' => array(
                    'title' => 'پیام پرداخت موفق',
                    'type' => 'textarea',
                    'description' => 'متن پیامی که میخواهید بعد از پرداخت موفق به کاربر نمایش دهید را وارد نمایید ، می توانید از شورت کد {transaction_id} نیز برای نمایش کد رهگیری تراکنش و از شرت کد {SaleOrderId} برای شماره درخواست استفاده نمایید .',
                    'default' => 'با تشکر از شما . سفارش شما با موفقیت پرداخت شد .',
                ),
                'failed_massage' => array(
                    'title' => 'پیام پرداخت ناموفق',
                    'type' => 'textarea',
                    'description' => 'متن پیامی که میخواهید بعد از پرداخت ناموفق به کاربر نمایش دهید را وارد نمایید ، می توانید از شورت کد {fault} نیز برای نمایش دلیل خطای رخ داده استفاده نمایید.',
                    'default' => 'پرداخت شما ناموفق بوده است . لطفا مجددا تلاش نمایید یا در صورت بروز اشکال با مدیر سایت تماس بگیرید .',
                ),
                'cancelled_massage' => array(
                    'title' => 'پیام انصراف از پرداخت',
                    'type' => 'textarea',
                    'description' => 'متن پیامی که میخواهید بعد از انصراف کاربر از پرداخت نمایش دهید را وارد نمایید . این پیام بعد از بازگشت از بانک نمایش داده خواهد شد .',
                    'default' => 'پرداخت به دلیل انصراف شما ناتمام باقی ماند .',
                ),
                'is_finish_order' => array(
                    'title' => 'پس از پرداخت سفارش به وضعیت تکمیل تغییر یابد. :',
                    'type' => 'checkbox',
                    'label' => 'اگر این گزینه انتخاب شود پس از پرداخت، سفارش به وضعیت <b>"تکمیل سفارش"</b> تغییر می یابد، در غیر اینصورت به وضعیت <b>"در حال آماده سازی"</b> تغییر می یابد.',
                    'default' => 'no'
                ),
                'base_url' => array(
                    'title' => 'آدرس پایه:',
                    'type' => 'text',
                    'label' => 'لطفا آدرس پایه را از شرکت پرداخت الکترونیک پاسارگاد دریافت کنید:',
                    'default' => 'https://pep.shaparak.ir/pepg'
                ),
            );
        }

        public function admin_options()
        {
            echo '<h3>تنظیمات درگاه پرداخت الکترونیک پاسارگاد :</h3>';
            echo '<table class="form-table">';
            $this->generate_settings_html();
            echo '</table>';
        }

        public static function PepPayRequest($InvoiceNumber, $TerminalCode, $MerchantCode, $Amount, $RedirectAddress, $Mobile = '', $Email = '')
        {
            $us = self::$username_p;
            $pa = self::$password_p;
            $data = array(
                'username' => $us,
                'password' => $pa
            );

            //take token
            self::$token_p = self::GetToken()->token;

            $result = "";
            if ( isset(self::$token_p)) {
                $curl = curl_init();
                $date   = new DateTime();
                $d = $date->format('Y-m-d H:i:s');
                curl_setopt_array($curl, array(
                CURLOPT_URL => self::$base_url . '/api/payment/purchase',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS =>'{
                "amount":' . strval($Amount) . ',
                "callbackApi": "' . $RedirectAddress . '",
                "description":"",
                "invoice": "' . strval($InvoiceNumber) .'",
                "invoiceDate":"'. $d . '",
                "mobileNumber":"",
                "serviceCode": "8",
                "serviceType": "PURCHASE",
                "payerMail": "",
                "payerName": "",
                "terminalNumber":"' . self::removeNoNumber($TerminalCode) . '",
                "nationalCode": "",
                "paymentCode":"0"
                }',
                CURLOPT_HTTPHEADER => array(
                    'Authorization: Bearer ' . self::$token_p ,
                    'Content-Type: application/json'
                ),
                ));
                
                $response = curl_exec($curl);
                $result = json_decode($response);
                
                
                curl_close($curl);


                if (isset($response) && (isset($result->resultCode)) ){
                    if($result->resultCode == 0)
                        self::d_redirect($result->data->url);
                    else
                        self::display_error($result->resultCode, '', strval($InvoiceNumber), 0, isset($Request->Message) ? $Request->Message : 'خطای نامشخص');
                }else{
                    self::display_error(110003, '', strval($InvoiceNumber), 0, isset($Request->Message) ? $Request->Message : 'خطای نامشخص');
                }


            }
            return $result;
        }

        public static function PepVerifyRequest($InvoiceNumber, $urlId, $Tokent)
        {


            $curl = curl_init();

            curl_setopt_array($curl, array(
            CURLOPT_URL => self::$base_url . '/api/payment/verify-transactions',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS =>'{
            "invoice": "'. $InvoiceNumber . '",
            "urlId": "'. $urlId . '"
            }
            ',
            CURLOPT_HTTPHEADER => array(
                'Authorization: Bearer ' . $Tokent,
                'Content-Type: application/json',
            ),
            ));

            $response = curl_exec($curl);
            
            $result = json_decode( $response);
            curl_close($curl);

            return $result;
        }

        public static function PepReversalRequest($InvoiceNumber, $urlId,$Tokent)
        {
            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL => self::$base_url . '/api/payment/reverse-transactions',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS =>'{"invoice":"'. $InvoiceNumber . '","urlId": "'. urlId .'"}',
                CURLOPT_HTTPHEADER => array(
                    'Authorization: Bearer '  . $Tokent,
                    'Content-Type: application/json'
                ),
            ));

            $response = curl_exec($curl);
            $result = json_decode( $response);
            curl_close($curl);
            return $result;
        }

        public static function PecStatus($code = '', $error_page = 0)
        {

            switch ($code) {
                case '1':
                    $response = 'ناموفق';
                    break;
                case '2':
                    $response = 'نامشخص';
                    break;
                case '401':
                    $response = 'مجاز به استفاده از سیستم نیستید.';
                    break;
                case '500':
                    $response = 'خطای داخلی سرور.';
                    break;
                case '13000':
                    $response = 'ورودی نامعتبر است.';
                    break;
                case '13001':
                    $response = 'آدرس نامعتبر است.';
                    break;
                case '13002':
                    $response = 'توکن نامعتبر است.';
                    break;
                case '13003':
                    $response = 'کد رهگیری یکتا نیست.';
                    break;
                case '13004':
                    $response = 'توکن خالی است.';
                    break;
                case '13005':
                    $response = 'عدم امکان دسترسی موقت به سرور.';
                    break;
                case '13007':
                    $response = 'کپچا منقضی شده است.';
                    break;
                case '13008':
                    $response = 'کپچا اشتباه است.';
                    break;
                case '13009':
                    $response = 'توکن منقضی شده است.';
                    break;
                case '13010':
                    $response = 'شماره موبایل نامعتبر است.';
                    break;
                case '13011':
                    $response = 'کد محصول نامعتبر است.';
                    break;
                case '13012':
                    $response = 'شناسه قبض نامعتبراست';
                    break;
                case '13013':
                    $response = 'شناسه پرداخت نامعتبراست';
                    break;
                case '13015':
                    $response = 'برای فراخوانی مجدد 2 دقیقه صبر کنید';
                    break;
                case '13016':
                    $response = 'تراکنش یافت نشد';
                    break;
                case '13017':
                    $response = 'طول ورودی نامعتبراست';
                    break;
                case '13018':
                    $response = 'یافت نشد';
                    break;
                case '13019':
                    $response = 'کد رهگیری برای کاربر لاگین شده در سیستم وجود ندارد';
                    break;
                case '13020':
                    $response = 'خطا هنگام چک کردن کد شرکت ';
                    break;
                case '13021':
                    $response = 'پرداخت از پیش لغو شده است ';
                    break;
                case '13022':
                    $response = 'تراکنش پرداخت نشده است ';
                    break;
                case '13025':
                    $response = 'تراکنش ناموفق است ';
                    break;
                case '13026':
                    $response = 'شماره کارت نامعتبراست';
                    break;
                case '13027':
                    $response = 'شماره موبایل برای شماره کارت وارد شده نیست';
                    break;
                case '13028':
                    $response = 'آدرس کالبک نامعتبراست';
                    break;
                case '13029':
                    $response = 'تراکنش موفق و تایید شده است';
                    break;
                case '13030':
                    $response = 'تراکنش تایید شده و ناموفق است ';
                    break;
                case '13031':
                    $response = 'تراکنش منتظر تایید است';
                    break;
                case '13033':
                    $response = 'تراکنش و بازگشت تراکنش با موفقیت انجام شده است ';
                    break;
                case '13035':
                    $response = 'تراکنش مجاز به انجام عملیات بازگشت نمی باشد';
                    break;
                case '130241':
                    $response = 'مبلغ شناسه پرداخت و مبلغ وروردی یکسان نیست ';
                    break;
                case '130242':
                    $response = 'تراکنش با موفقیت برگشت داده شد';
                    break;
                case '130243':
                    $response = 'تراکنش تایید نشد و برگشت داده شد';
                    break;
                case '130244':
                    $response = 'تراکنش با مغایرت مواجه شد';
                    break;
                case '110001':
                    $response = 'این سفارش قبلا تکمیل شده است.';
                    break;
                case '110002':
                    $response = 'توکن دریافت نشد.';
                    break;
                case '110003':
                    $response = 'خطا در انتقال به صفحه پرداخت.';
                    break;
				case '13063':
					$response = 'مبلغ کافی نیست.';
                    break;
                default:
                    $response = 'تراکنش انجام نشد';
                    break;
            }

            return $response;
        }

        public static function PecReservoir($type, $params)
        {
            $post = "type=$type";
            foreach ($params as $key => $value) {
                $post .= "&$key=$value";
            }
            $curl = curl_init();
            curl_setopt($curl, CURLOPT_URL, 'https://pep.co.ir/dl/check_update/wordpress/index.php');
            curl_setopt($curl, CURLOPT_POSTFIELDS, $post);
            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            $result = json_decode(curl_exec($curl));
            curl_close($curl);
            return $result;
        }

        public static function display_error($pay_status = '', $tran_id = '', $order_id = '', $is_callback = 1, $message = '')
        {

            $page_title='';
            $page_html = '<div align="center" dir="rtl" style="font-family:tahoma;font-size:12px;line-height: 25px;color:#000000;margin: -25px 0px -23px 0px;">';
            
                
            switch($pay_status)
            {
                case 13022:
                    $page_title = $admin_mess = 'پرداخت انجام نشد.';
                    $page_html .= '<span style="color:#ff0000;"><b>'. $admin_mess . '</b></span><br/>';
                    $page_html .= '<p style="margin-right:15px;font-size: 12px;margin: 15px 0px 20px 0px;line-height: 25px;">';
                    $page_html .= self::PecStatus($pay_status);
                    $page_html .= '</p>';
                    $page_html .= '<a href="' . get_option('siteurl') . '" style="text-decoration:none;">بازگشت به صفحه نخست >></a><br/>';    
                    
                    break;
                case 13029:
                    $page_title = 'این تراکنش پیش از این موفق شده است';
                    $page_html .= '<span style="color:#008800;"><b>'. self::PecStatus($pay_status) .'</b></span><br/>';
                    $page_html .= '<p style="margin-right:15px;font-size: 12px;margin: 15px 0px 20px 0px;line-height: 25px;">';
                    $page_html .= "تراکنش شما پیش از این با شماره پیگیری $tran_id با موفقیت ثبت شده است";
                    $page_html .= '</p>';
                    $page_html .= '<a href="' . get_option('siteurl') . '" style="text-decoration:none;">بازگشت به صفحه نخست >></a><br/>';    
                    break;
                case 110001:
                    $page_title = 'سفارش پیش از این موفق شده است';
                    $page_html .= '<span style="color:#008800;"><b>'. self::PecStatus($pay_status) .'</b></span><br/>';
                    $page_html .= '<p style="margin-right:15px;font-size: 12px;margin: 15px 0px 20px 0px;line-height: 25px;">';
                    $page_html .= "این سفارش قبلا با موفقیت ثبت شده است";
                    $page_html .= '</p>';
                    $page_html .= '<a href="' . get_option('siteurl') . '" style="text-decoration:none;">بازگشت به صفحه نخست >></a><br/>';
                    break;
                case 110002:
                    $page_title = $admin_mess = 'خطا در دریافت توکن';
                    $page_html .= '<span style="color:#ff0000;"><b>'. self::PecStatus($pay_status) .'</b></span><br/>';
                    $page_html .= '<p style="margin-right:15px;font-size: 12px;margin: 15px 0px 20px 0px;line-height: 25px;">';
                    $page_html .= self::PecStatus($pay_status);
                    $page_html .= '</p>';
                    $page_html .= '<a href="' . get_option('siteurl') . '" style="text-decoration:none;">بازگشت به صفحه نخست >></a><br/>';
                    break;
                case 110003:
                    $page_title = 'خطا در پرداخت ';
                    $page_html .= '<span style="color:#ff0000;"><b> خطا در پرداخت </b></span><br/>';
                    $page_html .= '<p style="margin-right:15px;font-size: 12px;margin: 15px 0px 20px 0px;line-height: 25px;">';
                    $page_html .= self::PecStatus($pay_status);
                    $page_html .= '</p>';
                    $page_html .= '<a href="' . get_option('siteurl') . '" style="text-decoration:none;">بازگشت به صفحه نخست >></a><br/>';
                    break;
                case 13018:
                    $page_title = 'خطا در پرداخت ';
                    $page_html .= '<span style="color:#ff0000;"><b> خطا در پرداخت </b></span><br/>';
                    $page_html .= '<p style="margin-right:15px;font-size: 12px;margin: 15px 0px 20px 0px;line-height: 25px;">';
                    $page_html .= self::PecStatus($pay_status);
                    $page_html .= '</p>';
                    $page_html .= '<a href="' . get_option('siteurl') . '" style="text-decoration:none;">بازگشت به صفحه نخست >></a><br/>';
                    break;

				

				default:
					$page_title = 'خطا در پرداخت';
					$page_html .= '<span style="color:#ff0000;"><b> خطا در پرداخت </b></span><br/>';
					$page_html .= '<p style="margin-right:15px;font-size: 12px;margin: 15px 0px 20px 0px;line-height: 25px;">';
					$page_html .= self::PecStatus($pay_status);
					$page_html .= '</p>';
					$page_html .= '<a href="' . get_option('siteurl') . '" style="text-decoration:none;">بازگشت به صفحه نخست >></a><br/>';
					break;
            }
           
            $page_html .= '</div>';

                //die(var_dump($pay_status));
            if (isset($admin_mess) && $order_id != '' && $pay_status != 'order_not_for_this_person') {

                try {
                    $order = new WC_Order(substr($order_id, 0, -2));
                    $order->add_order_note($admin_mess);

                } catch (Exception $e) {
                    $order = new WC_Order(($order_id));
                    $order->add_order_note($admin_mess);
                }
            }

            if($is_callback == 1) {

                wp_die($page_html, $page_title);
            }
            else {

                echo $page_html;
            }
        }


        public static function d_redirect($url = '')
        {
            if ($url != '') {
                if (headers_sent()) {
                    echo '<script type="text/javascript">window.location.assign("' . $url . '")</script>';
                } else {
                    header("Location: $url");
                }
                exit();
            }
        }

        public function process_payment($order_id)
        {
            $order = new WC_Order($order_id);
            return array(
                'result' => 'success',
                'redirect' => $order->get_checkout_payment_url(true)
            );
        }

        public static function removeNoNumber($str){
            $result = "";
            for($i=0; $i < strlen($str); $i++)
                if( is_numeric( $str[$i]) )
                    $result .= $str[$i];

            return $result;            
        }

        public function receipt_page($order_id)
        {

            global $woocommerce;
            $order = new WC_Order($order_id);
            $currency = $order->get_currency();
            
            $amount = intval($order->get_total());
            
            if (strtolower($currency) == strtolower('IRT') || strtolower($currency) == strtolower('TOMAN')
                || strtolower($currency) == strtolower('Iran TOMAN') || strtolower($currency) == strtolower('Iranian TOMAN')
                || strtolower($currency) == strtolower('Iran-TOMAN') || strtolower($currency) == strtolower('Iranian-TOMAN')
                || strtolower($currency) == strtolower('Iran_TOMAN') || strtolower($currency) == strtolower('Iranian_TOMAN')
                || strtolower($currency) == strtolower('تومان') || strtolower($currency) == strtolower('تومان ایران')
            )
                $amount = $amount * 10;
            else if (strtolower($currency) == strtolower('IRHT'))
                $amount = $amount * 1000 * 10;
            else if (strtolower($currency) == strtolower('IRHR'))
                $amount = $amount * 1000;

            $TerminalID = self::removeNoNumber($this->pasargad_terminal_id);
            
            $MerchantID = $this->pasargad_merchant_id;
            $CallBackUrl = $this->redirect_uri . "?order_id=" . $order_id;
            
            $order_id = $order_id . mt_rand(10, 99);
            
            $Request = self::PepPayRequest($order_id, $TerminalID, $MerchantID, $amount, $CallBackUrl);
           
            if (isset($Request) && $Request->resultCode == 0) {
                self::d_redirect('https://pep.shaparak.ir/payment.aspx?n=' . $Request->Token);
            }
            else {
                self::display_error($Request->resultCode, '', $order_id, 0, isset($Request->Message) ? $Request->Message : 'خطای نامشخص');
            }

            return false;
        }


        public static function GetToken(){
            //take token
            $us = self::$username_p;
            $pa = self::$password_p;
            $data = array(
                'username' => $us,
                'password' => $pa
            );
            $curl = curl_init(self::$base_url . '/token/getToken');
            curl_setopt($curl, CURLOPT_POST, 1);
            curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data));
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
            $s = curl_exec($curl);
            $result = json_decode($s);
            curl_close($curl);
            
                
            if (!isset($result) || !isset($result->token)){
                self::display_error(110002, '', '', 1, 'خطای در دریافت توکن');
                exit;
            }elseif ( isset($result->resultCode) && $result->resultCode !=0 ){
                self::display_error(isset($result->resultCode) ? $result->resultCode : null, '', '', 0, self::PecStatus($result->resultCode));
                exit;
            }

            return ($result);
        }

        public function PaymentInquery($invoiceId){
        
            $tk =  isset(self::GetToken()->token) ? self::GetToken()->token: '';
            $error_code = isset($tk) ? null : 'توکن نامعتبر است';
            $TransactionReferenceID ='';

            if (isset($error_code)){
                self::display_error(isset($error_code) ? $error_code : null, $TransactionReferenceID, $sessionid, 1, isset($message) ? $message : '');
                exit;
            }
            
            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => self::$base_url . '/api/payment/payment-inquiry',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS =>'{
                  "invoiceId": "' .  $invoiceId . '"
              }',
                CURLOPT_HTTPHEADER => array(
                  'Authorization: Bearer ' . self::GetToken()->token,
                  'Content-Type: application/json'
                ),
              ));
  
              $response = curl_exec($curl);
              curl_close($curl);

              return($response);
        }


        public function callback()
        {
            
            global $woocommerce;
            $order_id = isset($_GET['order_id']) ? $_GET['order_id'] : '';
            $invoiceId = isset($_GET['invoiceId']) ? $_GET['invoiceId'] : '';

            $InvoiceNumber = isset($invoiceId) ? $invoiceId : '';
            $InvoiceNumber = self::removeNoNumber($InvoiceNumber);
            $order_id= self::removeNoNumber($order_id);
            
            
            $InvoiceDate = isset($_REQUEST['iD']) ? $_REQUEST['iD'] : '';
            $TerminalID = self::removeNoNumber($this->pasargad_terminal_id);
            $MerchantID = $this->pasargad_merchant_id;

            $TransactionReferenceID="";


            if ($order_id == substr($InvoiceNumber, 0, -2)) {
                 
                $order = new WC_Order($order_id);
                //$order =  wc_get_order($order_id);
                
                
                $is_finish_ord = $this->is_finish_order;

                $new_state = 'processing';
                if($is_finish_ord != 'no')
                    $new_state = 'completed';
                    

//die(var_dump($invoiceId));


//die(var_dump($order->get_status()));

                if (isset($order->id)) {    
                    
                    if ($order->get_status() == 'wc-completed') {
                        $error_code = '110001';
                    } else {
                        
                        if ($invoiceId != '') {
                            $checkResult = self::PaymentInquery($invoiceId);
							 $checkResult = json_decode($checkResult);
                        } else {
                            $checkResult = null; //self::PepCheckTransactionResult(null, $InvoiceNumber, $InvoiceDate, $TerminalID, $MerchantID);
                        }

                        //die(var_dump($checkResult ));

                        if (isset($checkResult->resultCode) && isset($checkResult) && ( $checkResult->resultCode == 0 || $checkResult->resultCode == 13031) ) {
                            //$checkResult = json_decode($checkResult);
                            
                            $data = $checkResult->data;

                            //die(var_dump($data->url));
                            $url = $data->url;
                            $TransactionReferenceID = $data->referenceNumber;



                            $Request = self::PepVerifyRequest($InvoiceNumber, $url, self::GetToken()->token);

                             
                            if (isset($Request) && ($Request->resultCode==0 || $Request->resultCode==13029) ) {
                                
                                

                                $is_finish_ord = $this->is_finish_order;
                
                                $new_state = 'processing';
                                if($this->is_finish_order == 'yes')
                                    $new_state = 'completed';
                                    
                                
                                

                                if ($order->update_status($new_state)) {
                                    $order->payment_complete();
                                    $order->add_order_note('پرداخت شما با موفقیت با شماره پیگیری ' . $TransactionReferenceID . ' انجام شد.', 1);
                                    $woocommerce->cart->empty_cart();
                                    wp_redirect($this->get_return_url($order));
                                    exit();
                                } else {
                                    $reversal_request = self::PepReversalRequest($InvoiceNumber,  $url, self::GetToken()->token);
                                    if (isset($reversal_request) && $reversal_request->IsSuccess) {
                                        $error_code = 'reversal_done';
                                    } else {
                                        $error_code = 'reversal_error';
                                    }
                                }
                            }
                            else {
                                //die(var_dump($new_state));
                                //Error set Moslem
                                //$checkResult = json_decode($checkResult);
                                $message = $checkResult->resultMsg;
                                $error_code =  $checkResult->resultCode;
                            }
                        }
                        else {
                            //Error set Moslem
                            $error_code = $checkResult->resultCode;
							//die(var_dump($error_code));
                        }
                    }
                } else {
                    $error_code = 'order_not_exist';
                }
            }
            else {
                $error_code = 'order_not_for_this_person';
            }
                            
            //die(var_dump($error_code));        
            self::display_error(isset($error_code) ? $error_code : null, $TransactionReferenceID, $order_id, 1, isset($message) ? $message : '');
            exit;
        }

        public static function pep_wpwc_plugin_action_links($links, $file)
        {
            static $this_plugin;

            if (false === isset($this_plugin) || true === empty($this_plugin)) {
                $this_plugin = plugin_basename(__FILE__);
            }

            if ($file == $this_plugin) {
                $settings_link = '<a href="' . admin_url('admin.php?page=wc-settings&tab=checkout&section=pasargad') . '">تنظیمات</a>';
                array_unshift($links, $settings_link);
            }

            return $links;
        }
    }

    function woocommerce_add_pasargad_gateway_method($methods)
    {
        $methods[] = 'WC_Pasargad_Gateway';
        return $methods;
    }

    add_filter('woocommerce_payment_gateways', 'woocommerce_add_pasargad_gateway_method');
}

add_action('plugins_loaded', 'woocommerce_pasargad_payment_init', 0);
