<?php
defined('ABSPATH') || die('Access Denied!');

define('SEP_WOO_IRANDARGAH_PATH', plugin_dir_path(__FILE__));
define('SEP_WOO_IRANDARGAH_URL', trailingslashit(plugin_dir_url(__FILE__)));

final class SepWooPaymentIrandargah
{
    const MINIMUM_PHP_VERSION = '7.*.*';

    private static $_instance;

    public function __construct()
    {
        define("SEP_WOO_IMAGE", SEP_WOO_IRANDARGAH_URL . 'assets/images/');

        add_action('init', array($this, 'i18n'));

        if (version_compare(PHP_VERSION, self::MINIMUM_PHP_VERSION, '<')) {
            add_action('admin_notices', array($this, 'admin_notice_minimum_php_version'));
            return;
        }

        $active_plugin = get_option('active_plugins');
        if (!in_array('woocommerce/woocommerce.php', $active_plugin)) {
            add_action('admin_notices', array($this, 'admin_notice_check_woocommerce'));
            return;
        }

        add_filter('woocommerce_payment_gateways', [$this, 'add_method_gateway_callback']);
        add_action('woocommerce_blocks_loaded', [$this, 'SepWooBlock']);

        require_once SEP_WOO_IRANDARGAH_PATH . "/gateway/wc-sep-payment-gateway.php";
        require_once SEP_WOO_IRANDARGAH_PATH . "/dashboard/class-sep-dashboard.php";

        SEP_Dashboard::get_instance();
    }

    public function i18n()
    {
        load_plugin_textdomain('sb24wc', false, dirname(plugin_basename(__FILE__)) . '/languages/');
    }

    public function admin_notice_minimum_php_version()
    {
        $message = sprintf(
            esc_html__('"%1$s" requires version "%2$s" %3$s or higher.', 'sb24wc'),
            '<strong>' . esc_html__('Saman Payment Gateway Plugin', 'sb24wc') . '</strong>',
            '<strong>' . esc_html__('PHP', 'sb24wc') . '</strong>',
            7
        );

        printf('<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message);
    }

    public function admin_notice_check_woocommerce()
    {
        $class = 'notice notice-error';
        $message = __('WooCommerce extension is not installed/activated, please proceed with installation or activation.', 'sb24wc');

        $all_plugins = get_plugins();
        $url_woocommerce = "";
        $label = "";

        if (!array_key_exists('woocommerce/woocommerce.php', $all_plugins)) {
            $url_woocommerce = add_query_arg(array(
                's' => 'woocommerce',
                'tab' => 'search',
                'type' => 'term',
            ), admin_url('plugin-install.php'));
            $label = __('Install WooCommerce', 'sb24wc');
        } else if (!is_plugin_active('woocommerce/woocommerce.php')) {
            $url_woocommerce = esc_url(admin_url('plugins.php'));
            $label = __('WooCommerce activation', 'sb24wc');
        }

        printf(
            '<div class="%1$s"><p>%2$s <a href="%3$s" class="button button-primary" style="margin: 0 5px">%4$s</a></p></div>',
            esc_attr($class),
            esc_html($message),
            esc_url($url_woocommerce),
            esc_html($label)
        );
    }

    public function add_method_gateway_callback($methods)
    {
        $methods[] = 'WC_Sep_Payment_Gateway';

        return $methods;
    }

    public function SepWooBlock()
    {
        if (class_exists('Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType')) {
            add_action('woocommerce_blocks_payment_method_type_registration', function (Automattic\WooCommerce\Blocks\Payments\PaymentMethodRegistry $registerPayment) {
                require_once SEP_WOO_IRANDARGAH_PATH . 'gateway/wc-sep-block.php';
                $registerPayment->register(new WC_SEP_BLOCK());
            });
        }
    }

    public static function get_instance()
    {
        if (null == self::$_instance) {
            self::$_instance = new SepWooPaymentIrandargah();
        }

        return self::$_instance;
    }
}

add_action('plugins_loaded', array('SepWooPaymentIrandargah', 'get_instance'));
